<?php
/*--------------------------------------------------------------------------------------------------
    OnGetSellingUnitStockInfoEvent.php 2020-03-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2016 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */
namespace Gambio\Shop\SellingUnit\Database\Unit\Events;


use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetSellingUnitStockInfoEventInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SellingUnitId;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SellingUnitStockInterface;
use ProductDataInterface;

class OnGetSellingUnitStockInfoEvent implements OnGetSellingUnitStockInfoEventInterface
{
    /**
     * @var SellingUnitId
     */
    protected $id;
    /**
     * @var ProductDataInterface
     */
    protected $product;
    /**
     * @var SellingUnitStockInterface
     */
    protected $stock;

    /**
     * @return SellingUnitId
     */
    public function id(): SellingUnitId
    {
        return $this->id;
    }

    /**
     * @return ProductDataInterface
     */
    public function product(): ProductDataInterface
    {
        return $this->product;
    }

    /**
     * OnGetSellingUnitStockInfoEvent constructor.
     * @param SellingUnitId $id
     * @param ProductDataInterface $product
     */
    public function __construct(SellingUnitId $id, ProductDataInterface $product)
    {

        $this->id = $id;
        $this->product = $product;
    }

    /**
     * @inheritDoc
     */
    public function stock(): SellingUnitStockInterface
    {
        return $this->stock;
    }

    /**
     * @inheritDoc
     */
    public function setStock(SellingUnitStockInterface $stock): void
    {
        $this->stock = $stock;
    }
}